/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (26/05/08)
 */   
package com.ejie.p06b.excel;

import java.text.DateFormat;
import java.util.ArrayList;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import javax.servlet.http.HttpServletRequest;

import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
//import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
//import org.apache.poi.xssf.usermodel.XSSFColor;


import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.general.P06BConstantes;



/**
 * Clase que gestiona la generacin del pdf
 */
public class P06BInformePetTramitagunePDF implements P06BIExcel {
    private static long numeroEXCEL = 0;
	
	//Todo bien --> Devuelve la ruta donde dejaremos el excel
	//Error --> 1 Error al generar el EXCEL
    public String getEXCEL(HttpServletRequest request) throws Exception {
		P06BLog.send(2,"P06BListadoExcel", "getEXCEL(...)");
		
    	P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS);

    	String idioma = (String)request.getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);	
		if (idioma == null || idioma.equals("") ){
			idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
		}
		
		numeroEXCEL=numeroEXCEL+1;
		String error="1";
		
		String excelFichero = P06BParametros.get("excel.informePetTramitagune")+numeroEXCEL+".excel";

//		Obtener el listado de corredores que cumplen los criterios de bsqueda
		ArrayList<P06B64T00Datatype> p06BInformeOtroDECDet2 = P06BCorredoresManager.getInstance().selectInformePetTramitagune();
		try {			
			//create a new file
			FileOutputStream out = new FileOutputStream(excelFichero);
			//create a new workbook
			FileInputStream inputStream = new FileInputStream(new File(P06BParametros.get("excel.informePetTramitagune")));
			XSSFWorkbook wb = new XSSFWorkbook(inputStream);
			XSSFSheet s = null;
			XSSFRow r = null;
			XSSFCell c = null;
			XSSFCellStyle cs = null;
			XSSFDataFormat format = wb.createDataFormat();
			short formatNumber = format.getFormat("#,###,###,##0");
			
			int sheet = 0;

			s = wb.getSheetAt(0);

			for(int i=0;i<2;i++){
				r = s.getRow(i);
				for(int j=0;j<8;j++){
		            int dato = ((i+1) * 10)+j+1;
					switch(dato){
						case 11: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f1_01"));
							break;
						}
						case 21: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f2_01"));
							break;
						}
						case 22: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f2_02"));
							break;
						}
						case 23: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f2_03"));
							break;
						}
						case 24: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f2_04"));
							break;
						}
						case 25: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f2_05"));
							break;
						}
						case 26: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f2_06"));
							break;
						}
						case 27: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f2_07"));
							break;
						}
						case 28: {
							c = r.getCell(j);				
							c.setCellValue(res.get("listados.excel02.t1f2_08"));
							break;
						}
					}
				}
			}

			int lineaDetalle = 2;
			
			P06B64T00Datatype p06B64T00Datatype = null;

			for(int i=0;i<p06BInformeOtroDECDet2.size();i++){
				p06B64T00Datatype = p06BInformeOtroDECDet2.get(i);
				
				byte columns = 8;
				
				r = s.getRow(lineaDetalle);
				if (r==null){
					r=s.createRow(lineaDetalle);						
				}
				for(int columnaAVolcar = 0;columnaAVolcar<columns;columnaAVolcar++){
					c = r.getCell(columnaAVolcar);
		            if (c==null){
		            	c = r.createCell(columnaAVolcar);
		            	cs = wb.createCellStyle();
		            	if (columnaAVolcar==7){
			            	cs.setWrapText(true);		            		
		            	}
		            }else{
			            cs = c.getCellStyle();
		            }
		            if (lineaDetalle==2){
						cs.setBorderTop(XSSFCellStyle.BORDER_MEDIUM);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }else if (lineaDetalle==p06BInformeOtroDECDet2.size()+1){
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_MEDIUM);
					}else{
						cs.setBorderTop(XSSFCellStyle.BORDER_THIN);
						cs.setBorderBottom(XSSFCellStyle.BORDER_THIN);
		            }
		            
		            c.setCellStyle(cs);		        					            	

		            int dato = ((sheet+1) * 100)+columnaAVolcar;
					switch(columnaAVolcar){
						case 0: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_MEDIUM);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
							cs.setDataFormat(formatNumber);
				            c.setCellValue(p06B64T00Datatype.getCorrelativo());
							break;
						}
						case 1: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
							DateFormat dateFormat = null;
				            c.setCellValue(P06BFecha.getFechaFormateadaFromIdioma(p06B64T00Datatype.getFecha(),idioma) + " " + P06BFecha.getHoraCompleta(p06B64T00Datatype.getFecha()));
							break;
						}
						case 2: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(res.get(p06B64T00Datatype.getProcedimientoVisible()));
							break;
						}
						case 3: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B64T00Datatype.getRegistryNumber());
							break;
						}
						case 4: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(p06B64T00Datatype.getExpediente());
							break;
						}
						case 5: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(res.get(p06B64T00Datatype.getFinalizadaVisible()));
							break;
						}
						case 6: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
				            c.setCellValue(res.get(p06B64T00Datatype.getEstadoVisible()));
							break;
						}
						case 7: {
							cs.setBorderLeft(XSSFCellStyle.BORDER_THIN);
							cs.setBorderRight(XSSFCellStyle.BORDER_MEDIUM);
				            c.setCellValue(p06B64T00Datatype.getMensajeError());
							break;
						}
					}
					switch(dato){
//						case 100: {
//							cs.setBorderLeft(XSSFCellStyle.BORDER_MEDIUM);
//							cs.setBorderRight(XSSFCellStyle.BORDER_THIN);
//				            c.setCellValue(p06B64T00Datatype.getD49_F1());								
//							break;
//						}
					}

				}
	            
				lineaDetalle++;
			}				
			
			wb.write(out);
			out.close();
			
		}catch(Exception e) {
			P06BLog.send(2,"P06BListadoExcel", "Error al generar excel:"+e.getMessage());
			return error;
		}
		return excelFichero;
	}
}